package com.wissamfawaz;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Stack;

public class Main {
    private BTNode<Character> root1;
    private BTNode<Integer> root2;

    List<Character> depthFirstValuesIter, depthFirstValuesRec;
    List<Character> breadthFirstValues;

    public Main() {
        root1 = new BTNode<>('A');
        BTNode<Character> root1Left = new BTNode<>('B');
        BTNode<Character> root1LeftLeft = new BTNode<>('D');
        BTNode<Character> root1LeftRight = new BTNode<>('E');
        BTNode<Character> root1Right = new BTNode<>('C');
        BTNode<Character> root1RightRight = new BTNode<>('F');

        root1.setLeft(root1Left);
        root1.setRight(root1Right);
        root1Left.setLeft(root1LeftLeft);
        root1Left.setRight(root1LeftRight);
        root1Right.setRight(root1RightRight);

        root2 = new BTNode<>(3);
        BTNode<Integer> root2Left = new BTNode<>(11);
        BTNode<Integer> root2LeftLeft = new BTNode<>(4);
        BTNode<Integer> root2LeftRight = new BTNode<>(2);
        BTNode<Integer> root2Right = new BTNode<>(4);
        BTNode<Integer> root2RightRight = new BTNode<>(1);

        root2.setLeft(root2Left);
        root2Left.setLeft(root2LeftLeft);
        root2Left.setRight(root2LeftRight);
        root2.setRight(root2Right);
        root2Right.setRight(root2RightRight);

        depthFirstValuesIter = new ArrayList<>();
        depthFirstValuesRec = new ArrayList<>();
        breadthFirstValues = new ArrayList<>();

    }

    public static void main(String[] args) {
        Main application = new Main();

        application.dfsTraversalIter();
        System.out.println(application.depthFirstValuesIter);
        application.dfsTraversalRec();
        System.out.println(application.depthFirstValuesRec);
        application.bfsTraversal();
        System.out.println(application.breadthFirstValues);

        char target = 'E';
        if (application.bTreeIncludes(target)) {
            System.out.println(target + " is part of binary tree.");
        } else {
            System.out.println(target + " is not part of binary tree.");
        }

        System.out.println("Sum: " + application.bTreeSum());
        System.out.println("Min: " + application.bTreeMin());
        System.out.println("Max path sum: " + application.bTreeMaxPathSum());

    }

    public void dfsTraversalIter() {
        // Time complexity: O(n)
        // Space complexity: O(n)
        if (root1 == null) {
            return;
        }

        Stack<BTNode<Character>> stack = new Stack<>();
        BTNode<Character> current;
        stack.push(root1);

        while (!stack.isEmpty()) {
            current = stack.pop();
            depthFirstValuesIter.add(current.getElement());

            if (current.getRight() != null) {
                stack.push(current.getRight());
            }

            if (current.getLeft() != null) {
                stack.push(current.getLeft());
            }
        }
    }

    public void dfsTraversalRec() {
        dfsTraversalRecUtil(root1);
    }

    private void dfsTraversalRecUtil(BTNode<Character> node) {
        // Time complexity: O(n)
        // Space complexity: O(h) ~ O(n)

        if (node == null) {
            return;
        }

        depthFirstValuesRec.add(node.getElement());
        dfsTraversalRecUtil(node.getLeft());
        dfsTraversalRecUtil(node.getRight());
    }

    public void bfsTraversal() {
        if (root1 == null) {
            return;
        }

        Queue<BTNode<Character>> queue = new LinkedList<>();
        BTNode<Character> current;
        queue.add(root1);

        while (!queue.isEmpty()) {
            current = queue.remove();
            breadthFirstValues.add(current.getElement());

            if (current.getLeft() != null) {
                queue.add(current.getLeft());
            }

            if (current.getRight() != null) {
                queue.add(current.getRight());
            }
        }
    }

    public boolean bTreeIncludes(char target) {
        return bTreeIncludesRec(target, root1);
    }

    private boolean bTreeIncludesRec(char target, BTNode<Character> node) {
        if (node == null) {
            return false;
        }

        if (node.getElement() == target) {
            return true;
        }

        return bTreeIncludesRec(target, node.getLeft()) ||
                bTreeIncludesRec(target, node.getRight());
    }

    public int bTreeSum() {
        return bTreeSumRec(root2);
    }

    private int bTreeSumRec(BTNode<Integer> node) {
        if (node == null) {
            return 0;
        }

        int leftSum = bTreeSumRec(node.getLeft());
        int rightSum = bTreeSumRec(node.getRight());

        return node.getElement() + leftSum + rightSum;
    }

    public int bTreeMin() {
        return bTreeMinRec(root2);
    }

    private int bTreeMinRec(BTNode<Integer> node) {
        if (node == null) {
            return Integer.MAX_VALUE;
        }

        int leftMin = bTreeMinRec(node.getLeft());
        int rightMin = bTreeMinRec(node.getRight());

        return Math.min(node.getElement(), Math.min(leftMin, rightMin));
    }

    public int bTreeMaxPathSum() {
        return bTreeMaxPathSumRec(root2);
    }

    private int bTreeMaxPathSumRec(BTNode<Integer> node) {
        if(node == null) {
            return Integer.MIN_VALUE;
        }

        if(node.getLeft() == null && node.getRight() == null) {
            return node.getElement();
        }

        int leftPathSum = bTreeMaxPathSumRec(node.getLeft());
        int rightPathSum = bTreeMaxPathSumRec(node.getRight());

        return node.getElement() + Math.max(leftPathSum, rightPathSum);
    }
}
